<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>شركات التنفيذ</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">

    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body class="bg-light text-center" style="font-family: 'Cairo', sans-serif;">

    <div class="container mt-5">
        <h2 class="mb-4">إضافة شركة تنفيذ</h2>

        <div class="input-group mb-3 justify-content-center">
            <input type="text" id="name" class="form-control w-50 text-end" placeholder="ادخل اسم الشركة">
            <button class="btn btn-primary" onclick="submitForm()">إرسال</button>
        </div>

        <div id="result" class="mt-4"></div>
    </div>

    <script>
        function submitForm() {
            const name = document.getElementById('name').value.trim();
            if (!name) {
                Swal.fire('خطأ', 'يرجى إدخال اسم الشركة', 'error');
                return;
            }

            fetch('insert.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: 'name=' + encodeURIComponent(name)
            })
            .then(res => res.json())
            .then(data => {
                if (data.status === 'exists') {
                    Swal.fire('موجود', 'الشركة موجودة بالفعل', 'info');
                } else if (data.status === 'inserted') {
                    Swal.fire('تم', 'تمت إضافة الشركة بنجاح', 'success');
                    loadTable();
                } else {
                    Swal.fire('خطأ', 'حدث خطأ أثناء الإضافة', 'error');
                }
                document.getElementById('name').value = '';
            });
        }

        function loadTable() {
            fetch('check.php')
                .then(res => res.text())
                .then(html => document.getElementById('result').innerHTML = html);
        }

        window.onload = loadTable;
    </script>
</body>
</html>
